﻿using System;
using gov.va.med.VBECS.Communication.Clients;
using gov.va.med.VBECS.Communication.Common;

namespace gov.va.med.VBECS.Communication.Channels
{
    /// <summary>
    /// Interface for sequential messaging functionality
    /// </summary>
    public interface ISequentialMessager : IMessager
    {
        /// <summary>
        /// Gets the underlying IClient object.
        /// </summary>
        IClient UnderlyingMessager { get; }

        /// <summary>
        /// Indicates if the messager is currently busy
        /// </summary>
        bool IsBusy { get; }

        /// <summary>
        /// Sends a message.
        /// </summary>
        /// <param name="aMessage">Message to be sent</param>
        /// <param name="theTimeoutMilliseconds">Timeout duration as milliseconds.</param>
        /// <param name="messageReseivedMethod">Method is called when reply message arrive</param>
        void Send(IMessage aMessage, int theTimeoutMilliseconds, Action<IMessage> messageReseivedMethod);

        /// <summary>
        /// Sends and Receives a message.
        /// </summary>
        /// <param name="aMessage">Message to be sent</param>
        /// <param name="theTimeoutMilliseconds">Timeout duration as milliseconds.</param>
        IMessage SendReceive(IMessage aMessage, int theTimeoutMilliseconds);
    }
}
